<?php

require('../pdf/fpdf.php');

class PDF extends FPDF {

function MultiCell($w,$h,$txt,$border=0,$align='J',$fill=0,$indent=0)
{
    //Output text with automatic or explicit line breaks
    $cw=&$this->CurrentFont['cw'];
    if($w==0)
        $w=$this->w-$this->rMargin-$this->x;

    $wFirst = $w-$indent;
    $wOther = $w;

    $wmaxFirst=($wFirst-2*$this->cMargin)*1000/$this->FontSize;
    $wmaxOther=($wOther-2*$this->cMargin)*1000/$this->FontSize;

    $s=str_replace("\r",'',$txt);
    $nb=strlen($s);
    if($nb>0 and $s[$nb-1]=="\n")
        $nb--;
    $b=0;
    if($border)
    {
        if($border==1)
        {
            $border='LTRB';
            $b='LRT';
            $b2='LR';
        }
        else
        {
            $b2='';
            if(is_int(strpos($border,'L')))
                $b2.='L';
            if(is_int(strpos($border,'R')))
                $b2.='R';
            $b=is_int(strpos($border,'T')) ? $b2.'T' : $b2;
        }
    }
    $sep=-1;
    $i=0;
    $j=0;
    $l=0;
    $ns=0;
    $nl=1;
        $first=true;
    while($i<$nb)
    {
        //Get next character
        $c=$s[$i];
        if($c=="\n")
        {
            //Explicit line break
            if($this->ws>0)
            {
                $this->ws=0;
                $this->_out('0 Tw');
            }
            $this->Cell($w,$h,substr($s,$j,$i-$j),$b,2,$align,$fill);
            $i++;
            $sep=-1;
            $j=$i;
            $l=0;
            $ns=0;
            $nl++;
            if($border and $nl==2)
                $b=$b2;
            continue;
        }
        if($c==' ')
        {
            $sep=$i;
            $ls=$l;
            $ns++;
        }
        $l+=$cw[$c];

        if ($first)
        {
            $wmax = $wmaxFirst;
            $w = $wFirst;
        }
        else
        {
            $wmax = $wmaxOther;
            $w = $wOther;
        }

        if($l>$wmax)
        {
            //Automatic line break
            if($sep==-1)
            {
                if($i==$j)
                    $i++;
                if($this->ws>0)
                {
                    $this->ws=0;
                    $this->_out('0 Tw');
                }
                $SaveX = $this->x; 
                if ($first and $indent >0)
                {
                    $this->SetX($this->x + $indent);
                    $first=false;
                }
                $this->Cell($w,$h,substr($s,$j,$i-$j),$b,2,$align,$fill);
                    $this->SetX($SaveX);
            }
            else
            {
                if($align=='J')
                {
                    $this->ws=($ns>1) ? ($wmax-$ls)/1000*$this->FontSize/($ns-1) : 0;
                    $this->_out(sprintf('%.3f Tw',$this->ws*$this->k));
                }
                $SaveX = $this->x; 
                if ($first and $indent >0)
                {
                    $this->SetX($this->x + $indent);
                    $first=false;
                }
                $this->Cell($w,$h,substr($s,$j,$sep-$j),$b,2,$align,$fill);
                    $this->SetX($SaveX);
                $i=$sep+1;
            }
            $sep=-1;
            $j=$i;
            $l=0;
            $ns=0;
            $nl++;
            if($border and $nl==2)
                $b=$b2;
        }
        else
            $i++;
    }
    //Last chunk
    if($this->ws>0)
    {
        $this->ws=0;
        $this->_out('0 Tw');
    }
    if($border and is_int(strpos($border,'B')))
        $b.='B';
    $this->Cell($w,$h,substr($s,$j,$i),$b,2,$align,$fill);
    $this->x=$this->lMargin;
    }
}
$InterLigne = 7;

$pdf=new PDF();
$pdf->Open();
$pdf->AddPage();
$pdf->SetMargins(30,10,30);
$pdf->SetFont('Arial','',12);

$txt = "Cher Pierre";
$txtLen = $pdf->GetStringWidth($txt);
$milieu = (210-$txtLen)/2;
$pdf->SetX($milieu);
$pdf->Write(5,$txt);

$pdf->ln(30);
$txt = "Voici venu le temps pour toi de renouveler ta licence-assurance, en effet celle-ci expire le 28/9 prochain. Tu trouveras joint  ce document le certificat d'aptitude  faire remplir par le mdecin.";
$pdf->MultiCell(0,$InterLigne,$txt,0,'J',0,15); 

$pdf->ln(10);
$txt = "Je me permets de te rappeler que cette licence est obligatoire et ncessaire  la pratique de notre sport favori, tant  l'occasion de nos entranements qu' toutes autres manifestations auxquelles tu peux participer telles que comptitions, cours fdraux ou visites amicales dans un autre club.";
$pdf->MultiCell(10,$InterLigne,$txt,0,1,'J',0,15); 

$pdf->ln(10);
$txt = "Ds lors, je te saurais gr de bien vouloir me retourner le certificat d'aptitude dment complt par le mdecin accompagn de ton paiement de 31  ou de la preuve de celui-ci par virement bancaire. Le tout dans les plus brefs dlais afin de ne pas interrompre la couverture de ladite assurance et par la mme occasion de t'empcher de participer  nos cours le temps de la rgularisation. Il y va de ta scurit.";
$pdf->MultiCell(0,$InterLigne,$txt,0,'J',0,15); 

$pdf->ln(10);
$txt = "Merci de la confiance que tu mets en notre club pour ton panouissement sportif.";
$pdf->MultiCell(0,$InterLigne,$txt,0,'J',0,15); 

$pdf->ln(10);
$txt = "Le comit";
$pdf->MultiCell(0,$InterLigne,$txt,0,'R',0); 

$pdf->Output();

?> 