<?php 
    date_default_timezone_set('America/Mexico_City');
?> 
<!DOCTYPE html>
<html>
    <head>
        <meta charset="UTF-8">
        <title>Asistencias</title>
     
        <link href="../css/crud/color.css" rel="stylesheet" type="text/css"/>
        <link href="../css/crud/easyui.css" rel="stylesheet" type="text/css"/>
        <link href="../css/crud/general.css" rel="stylesheet" type="text/css"/>
        <link href="../css/crud/icon.css" rel="stylesheet" type="text/css"/>
        <link href="css/main.css" rel="stylesheet" type="text/css"/>
        <link href="css/lightbox.css" rel="stylesheet" type="text/css"/>
        
        <script src="../js/jquery.min.js?3" type="text/javascript"></script>
        <script src="../js/jquery.easyui.min.js" type="text/javascript"></script>
        <script src="../js/datagrid-filter.js" type="text/javascript"></script>
        
        
    </head>
    <body>
      
        <p align="center"><img src="../css/crud/icons/asist.png" width="50px"/> </p>
        <h2 style="text-align:center">Asistencias</h2>
               
        <table id="dg" title="Asistencias" class="easyui-datagrid" style="width:100%;height:380px"
               url="get_data.php"
               toolbar="#tb" pagination="true"
               rownumbers="true" fitColumns="true" singleSelect="true">
            <thead>
                <tr> 
                    <th field="num_empleado" width="25">Numero Empleado</th>
                    <th field="nombre" width="60">Nombre</th>                    
                    <th field="fecha" width="50">Fecha</th>
                    <th field="hora" width="50">Hora</th>
                    <th field="tipo" width="50">Tipo</th>
                    <th width="25" data-options="field:'img',width:25,align:'center',formatter:foto">Foto</th>
                </tr>
            </thead>
        </table>
      
        <div id="tb" style="padding:3px">
            <span>Num Empleado:</span>
            <input id="n_emp" style="line-height:26px;border:1px solid #ccc">
            <span>Fecha:</span>
            <input type="date" id="fecha" style="line-height:26px;border:1px solid #ccc">
            <span>-</span>
            <input type="date" id="fecha2" style="line-height:26px;border:1px solid #ccc">
            <span>Tipo:</span>
            <input id="tipo" style="line-height:26px;border:1px solid #ccc">
             <button class="easyui-button"  onclick="doSearch()"/>Buscar</button>
            
	</div>  
        <div id="hd">
            <button id="pdf">PDF</button>
            <button id="excel">EXCEL</button> 
              <button id="excel1">Asistencias</button> 
          
        </div>
        <script> 
            function doSearch(){
			$('#dg').datagrid('load',{
				n_emp: $('#n_emp').val(),
                                fecha: $('#fecha').val(),
                                fecha2: $('#fecha2').val(),
                                tipo: $('#tipo').val()
			});
		}  
                
                function foto(val,row){
                   separador = "/";
                   var fecha = val.split(separador,3);   
                       fechac = fecha[2].substring(0,4)+"-"+fecha[2].substring(4,6)+"-"+fecha[2].substring(6,8);
                       hora = fecha[2].substring(8,10)+":"+fecha[2].substring(10,12)+":"+fecha[2].substring(12,14);
                   return '<a href="https://asistencia1.valorpoint.net/empleados/'+val+'" data-lightbox="foto" data-title="Fecha: '+fechac+' &nbsp&nbsp&nbsp\n\
                            Hora: '+hora+'"><img width="60" src="https://asistencia1.valorpoint.net/empleados/'+val+'"/></a>';
                }
                 
            $(document).ready(function(){
//                $('#dg').datagrid('enableFilter'); 
                
                $('#pdf').click(function(){
                    var n_emp = $('#n_emp').val();
                    var fecha = $('#fecha').val();
                    var fecha2 = $('#fecha2').val();
                    var tipo = $('#tipo').val();
                    location.href = "pdf.php?n_emp="+n_emp+"&fecha="+fecha+"&fecha2="+fecha2+"&tipo="+tipo;
                });
                $('#excel').click(function(){
                    var n_emp = $('#n_emp').val();
                    var fecha = $('#fecha').val();
                    var fecha2 = $('#fecha2').val();
                    var tipo = $('#tipo').val();
                    location.href = "excel.php?n_emp="+n_emp+"&fecha="+fecha+"&fecha2="+fecha2+"&tipo="+tipo;
                }); 
                $('#excel1').click(function(){
                    var n_emp = $('#n_emp').val();
                    var fecha = $('#fecha').val();
                    var fecha2 = $('#fecha2').val();
                    var tipo = $('#tipo').val();
                    location.href = "excel1.php?n_emp="+n_emp+"&fecha="+fecha+"&fecha2="+fecha2+"&tipo="+tipo;
                }); 
            });
            
        </script>
        
        <script src="js/lightbox.js" type="text/javascript"></script>
        <script>
            lightbox.option({
              'wrapAround': true,
              'fitImagesInViewport': true
            });
        </script> 
    </body>
</html>
