<?php

session_cache_limiter('private');
session_start();
$com = "I";
include("DMMYSQLG.php");
include("DSA3000.php");
include('DF80000.php');
require_once 'excel/PHPExcel.php';

date_default_timezone_set('America/Mexico_City');

$sql = mysqli_query($con ,"SELECT nparte1, np_desc1, t5 as cantidad, cos_prom, t3 from farticulos order by sub, nparte1");
$resultado = mysqli_num_rows($sql);

$fila = 2;

$objPHPExcel = new PHPExcel();
/* * *******************Add column headings START********************* */
$objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A1', 'Id')
        ->setCellValue('B1', 'Descripcion')
        ->setCellValue('C1', 'Cantidad')
        ->setCellValue('D1', 'Costo promedio')
        ->setCellValue('E1', 'Ultimo Costo');


// Fuente de la primera fila en negrita
$boldArray = array('font' => array('bold' => true,),'alignment' => array('horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER));
 
$objPHPExcel->getActiveSheet()->getStyle('A1:E1')->applyFromArray($boldArray);		
 
//Ancho de las columnas
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(8);	
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setWidth(30);	
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setWidth(15);	
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setWidth(20);	
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setWidth(20);
//imprimir resultados de consulta

while ($row = mysqli_fetch_assoc($sql)) {

    $objPHPExcel->getActiveSheet()->setCellValue('A' . $fila, $row['nparte1']);
    $objPHPExcel->getActiveSheet()->setCellValue('B' . $fila, $row['np_desc1']);
    $objPHPExcel->getActiveSheet()->setCellValue('C' . $fila, $row['cantidad']);
    $objPHPExcel->getActiveSheet()->setCellValue('D' . $fila, $row['cos_prom']);
    $objPHPExcel->getActiveSheet()->setCellValue('E' . $fila, $row['t3']);        

    $fila++;
}


// Redirigir la salida al navegador web de un cliente ( Excel5 )
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="reporte.xls"');
header('Cache-Control: max-age=0');
// Si usted est sirviendo a IE 9 , a continuacin, puede ser necesaria la siguiente
header('Cache-Control: max-age=1');
 
// Si usted est sirviendo a IE a travs de SSL , a continuacin, puede ser necesaria la siguiente
header ('Expires: Mon, 26 Jul 1997 05:00:00 GMT'); // Date in the past
header ('Last-Modified: '.gmdate('D, d M Y H:i:s').' GMT'); // always modified
header ('Cache-Control: cache, must-revalidate'); // HTTP/1.1
header ('Pragma: public'); // HTTP/1.0
 
$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');
?>
  

